/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	com Utility header file.


#pragma once

#include <math.h>

#define CONV_SUCCESS	0
#define CONV_FAILURE	-1
#define PI	3.14159265359

#ifdef __CCLIENT__

void __declspec(dllimport) TraceStartMethod(const CString &method);
void __declspec(dllimport) OnMethodFailure(HRESULT status);

#else

void __declspec(dllexport) TraceStartMethod(const CString &method);
void __declspec(dllexport) OnMethodFailure(HRESULT status);

#endif

#ifdef RUN_PRODESKTOP_CPP
	IApplication *pdApp;
#else
	extern IApplication *pdApp;
#endif

HRESULT AddSet(ISet *, ISet *);

#define CAST(cls, obj) \
	QueryInterface<cls>(obj,IID_##cls) \

template <class T> 
T *QueryInterface(IDispatch *disp,GUID iid)
{
	void *pUnk;
	HRESULT status = disp->QueryInterface(iid,(void **)&pUnk);
	if (FAILED(status)) { 
		ASSERT(FALSE);
		AfxThrowOleException(status);
	} 
	disp->Release();
	return (T *)pUnk;

}

#define GetCLASS(cls) \
	GetFormalClass<I##cls##Class>(IID_I##cls##Class, #cls) \

template <class T>
T *GetFormalClass(GUID iid, CString clsName)
{
	IDispatch *disp = NULL;
	HRESULT status = pdApp->GetClass(clsName.AllocSysString(), &disp);

	T *thisCls = NULL;
	status = disp->QueryInterface(iid, (void **)&thisCls);
	if(status || !thisCls) {
		AfxMessageBox("QueryInterface Failed");
		return NULL;
	}
	return thisCls;
}

#define START_METHOD(method) \
	try { \
		TraceStartMethod(#method); \
	
#define END_METHOD(method) \
	}  \
	catch (COleException *e) { \
		const SCODE code = e->m_sc; \
		e->Delete(); \
		return code; \
	} \
	return NOERROR; \

#define CHECK_RETURN_STATUS(status) \
	if (FAILED(status)) { \
		OnMethodFailure(status); \
	} \

#define CHECK_VAR_STATUS(var) \
	if (!var) { \
		OnMethodFailure(E_FAIL); \
	} \


